<div>
    <div class="modal fade" id="creditSettingsModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <!-- Modal Header -->
                <div class="modal-header">
                    <div class="d-flex align-items-center justify-content-between w-100">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                                <i class="bx bx-cog bx-lg"></i>
                            </div>
                            <div>
                                <h4 class="mb-1 fw-bold">إعدادات الائتمان العامة</h4>
                                <p class="mb-0 text-muted">تكوين حدود الائتمان والظهور لجميع الوكلاء</p>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                </div>

                <!-- Modal Body -->
                <div class="modal-body">
                    <div class="row">
                        <!-- Global Settings -->
                        <div class="col-md-3">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0 fw-bold text-end">الظهور</h6>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <div class="d-flex align-items-center justify-content-betwen px-2">
                                            <span class="form-label mb-0">ظهور صادر</span>
                                            <label class="switch m-0">
                                                <input type="checkbox" wire:model.live="general_global.send_transfer"
                                                    class="switch-input">
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on">ON</span>
                                                    <span class="switch-off">OFF</span>
                                                </span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <div class="d-flex align-items-center justify-content-betwen px-2">
                                            <span class="form-label mb-0">ظهور اعتماد</span>
                                            <label class="switch m-0">
                                                <input type="checkbox" wire:model.lazy="general_global.send_approval"
                                                    class="switch-input">
                                                <span class="switch-toggle-slider">
                                                    <span class="switch-on">ON</span>
                                                    <span class="switch-off">OFF</span>
                                                </span>
                                            </label>
                                        </div>
                                    </div>



                                </div>
                            </div>
                        </div>

                        <!-- Credit Limits -->
                        <div class="col-md-9">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0 fw-bold text-end">حدود المديونية</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label class="form-label text-end d-block">مقوم حوالات</label>
                                            <div class="d-flex align-items-center gap-2">
                                                <input type="number" class="form-control form-control-sm"
                                                    wire:model.lazy="general_global.base_credit_limit" step="0.01"
                                                    placeholder="0.00">
                                                <div>
                                                    <label class="switch m-0">
                                                        <input type="checkbox"
                                                            wire:model.live="general_global.transfer_status"
                                                            class="switch-input">
                                                        <span class="switch-toggle-slider">
                                                            <span class="switch-on">ON</span>
                                                            <span class="switch-off">OFF</span>
                                                        </span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label text-end d-block">مقوم اعتماد</label>
                                            <input type="number" class="form-control form-control-sm"
                                                wire:model.lazy="general_global.approval_credit_limit" step="0.01"
                                                placeholder="0.00">
                                        </div>
                                    </div>

                                    <!-- Currency Settings Table -->
                                    <div class="table-responsive">
                                        <table class="table table-sm table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-end">العملة</th>
                                                    <th class="text-center">صادر</th>
                                                    <th class="text-center">وارد</th>
                                                    <th class="text-end">حد المديونية</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($currencies as $currency)
                                                    <tr>
                                                        <td class="text-end">{{ $currency->name }}</td>
                                                        <td class="text-center">
                                                            <label class="switch">
                                                                <input type="checkbox" class="switch-input"
                                                                    wire:model.live="general_visibility.{{ $currency->code }}.send">
                                                                <span class="switch-toggle-slider">
                                                                    <span class="switch-on">on</span>
                                                                    <span class="switch-off">off</span>
                                                                </span>
                                                            </label>
                                                        </td>
                                                        <td class="text-center">
                                                            <label class="switch">
                                                                <input type="checkbox" class="switch-input"
                                                                    wire:model.live="general_visibility.{{ $currency->code }}.receive">
                                                                <span class="switch-toggle-slider">
                                                                    <span class="switch-on">on</span>
                                                                    <span class="switch-off">off</span>
                                                                </span>
                                                            </label>
                                                        </td>
                                                        <td class="text-end">
                                                            <input type="number" step="0.01"
                                                                wire:model.lazy="general_currecnyCreditLimit.{{ $currency->code }}.credit_limit"
                                                                class="form-control form-control-sm"
                                                                placeholder="0.00">
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="d-flex justify-content-between align-items-center mt-4">

                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                <i class="bx bx-x me-2"></i>إلغاء
                            </button>

                            <button type="button" class="btn btn-primary" wire:click="applyToAllAgents">
                                <i class="bx bx-cog me-2"></i>تطبيق على جميع الوكلاء
                            </button>
                        </div>
                    </div>

                    <!-- Success/Error Messages -->
                    @if (session()->has('success'))
                        <div class="alert alert-success mt-3 d-flex align-items-center">
                            <i class="bx bx-check-circle text-success me-2"></i>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session()->has('error'))
                        <div class="alert alert-danger mt-3 d-flex align-items-center">
                            <i class="bx bx-x-circle text-danger me-2"></i>
                            {{ session('error') }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Modal functionality - main function is defined in DataTable
    document.addEventListener('DOMContentLoaded', function() {
        // Handle modal close events
        const modal = document.getElementById('creditSettingsModal');
        if (modal) {
            modal.addEventListener('hidden.bs.modal', function() {
                // Reset form or perform cleanup if needed
                console.log('Credit settings modal closed');
            });
        }
    });

    // Livewire event listeners
    document.addEventListener('livewire:updated', function() {
        // You can add any post-update logic here
        console.log('Livewire updated - credit settings modal');
    });
</script>

<style>
    .modal-content {
        border-radius: 0.5rem;
    }

    .card {
        border-radius: 0.5rem;
    }

    .btn {
        border-radius: 0.5rem;
    }

    .switch {
        transform: scale(1.1);
    }

    .form-label {
        font-weight: 500;
    }

    .table th {
        background-color: #f8f9fa;
        font-weight: 600;
    }
</style>
