<div>
    <!-- Money Transfer Modal -->
    <div class="modal fade" id="MoneyCurrencyModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl modal-simple" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-6">
                        <h4 class="mb-2">{{ __('currency.add_new_currency') }}</h4>

                    </div>
                    <div class="col-xxl">
                        <div class="card mb-6">

                            <div class="card-body">
                                <form wire:submit.prevent="SaveCurrency">
                                    <div class="row mb-4 ">
                                        <div class="col-md-6 select2_content">
                                            <label for="currency-code"
                                                class="form-label">{{ __('currency.code') }}</label>

                                            @if ($editing)
                                                <!-- Show readonly input when editing -->
                                                <input type="text" class="form-control" id="currency-code"
                                                    value="{{ $currency['code'] ?? '' }}" readonly>
                                            @else
                                                <!-- Show select dropdown when creating new -->
                                                <x-Mulk.select2 tabindex="1" :key="'currency.code'"
                                                    wire:model.live="currency.code" class="form-select">
                                                    <option value="__custom">Custom Code</option>
                                                    @foreach ($currencies as $curr)
                                                        <option value="{{ $curr['code'] }}">
                                                            {{ $curr[app()->getLocale()] }}
                                                        </option>
                                                    @endforeach
                                                </x-Mulk.select2>
                                                @error('currency.code')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            @endif
                                        </div>

                                        @if ($this->currency['code'] === '__custom')
                                            <div class="col-md-6 select2_content">
                                                <label for="currency-custom_code"
                                                    class="form-label">{{ __('currency.code') }}</label>
                                                <input tabindex="2" type="text" id="currency-custom_code"
                                                    class="form-control" placeholder="Custom Code"
                                                    wire:model="custom_code">

                                                @error('custom_code')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        @endif
                                    </div>

                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <label for="recipient-name"
                                                class="form-label">{{ __('general.name') }}</label>
                                            <input tabindex="4" type="text" id="currency-name" class="form-control"
                                                wire:model="currency.name.{{ app()->getLocale() }}">
                                            @error('currency.name')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="col-md-6">
                                            <label for="recipient-name"
                                                class="form-label">{{ __('currency.color') }}</label>
                                            <input tabindex="4" type="color" id="currency-colot"
                                                class="form-control" wire:model="currency.color">
                                            @error('currency.color')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                    </div>


                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <label for="recipient-name"
                                                class="form-label">{{ __('currency.exchange_rate') }}</label>
                                            <input tabindex="4" type="text" id="currency-rate" class="form-control"
                                                wire:model="currency.exchange_rate">
                                            @error('currency.exchange_rate')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">{{ __('currency.rate_factor') }}</label>
                                            <select class="form-select" wire:model="currency.rate_factor">
                                                <option value="multiply">{{ __('currency.multiply') }} (×)</option>
                                                <option value="divide">{{ __('currency.divide') }} (÷)</option>
                                            </select>
                                            @error('currency.rate_factor')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror

                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label">{{ __('currency.order_id') }}</label>
                                            <input type="number" class="form-control" wire:model="currency.order_id">
                                            @error('currency. <input type="number" class="form-control"
                                                    wire:model="currency.order_id">
                                                ')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror

                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label">{{ __('currency.avatar') }}</label>
                                            <input type="file" class="form-control" wire:model="avatar">
                                            @error('avatar')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    @if ($currency_object)
                                        <div class="row mb-4">
                                            <div class="col-md-6">
                                                <img src="{{ $currency_object->getAvatar() }}"
                                                    class="img-fluid rounded" alt="Currency Avatar"
                                                    style="max-width: 100px;">
                                            </div>
                                        </div>
                                    @endif

                                    <label class="switch">
                                        <input type="checkbox" class="switch-input" name="is_default"
                                            wire:model="currency.is_default">
                                        <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                        </span>
                                        <span class="switch-label">{{ __('currency.set_as_default') }}</span>
                                    </label>


                                    <div class="row mt-4">
                                        <div class="col-12 text-end">
                                            <button tabindex="11" type="submit" class="btn btn-primary">
                                                <i class="ti ti-device-floppy"></i> {{ __('actions.save') }}
                                            </button>
                                        </div>
                                    </div>
                                </form>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
