<div wire:poll.10s="refreshRates">

    <table class="table  table-bordered text-right">
        <thead>
            <tr>
                <th>{{ __('exchange.currency') }}</th>
                <th>{{ __('exchange.buy') }}</th>
                <th>{{ __('exchange.sell') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($groupedRates as $pair => $data)
                <tr style="cursor: pointer" @class([
                    'table-primary' =>
                        $data['from'] === $selectedFrom && $data['to'] === $selectedTo,
                ]) x-data>
                    <td>

                        <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                            <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top"
                                class="avatar avatar-xs pull-up" title="دولار">
                                <img src="{{ $data['from_avatar'] }}" alt="Avatar" class="rounded-circle" />
                            </li>
                            <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top"
                                class="avatar avatar-xs pull-up" title="ليرة">
                                <img src="{{ $data['to_avatar'] }}" alt="Avatar" class="rounded-circle" />
                            </li>
                            {{ $pair }}

                        </ul>
                    </td>

                    {{-- Buy --}}
                    <td
                        @click.stop="$wire.setExchange('{{ $data['from'] }}', '{{ $data['to'] }}', {{ $data['buy'] ?? 0 }}, 'buy', '{{ e($data['buy_factor'] ?? '') }}')">
                        <strong class="clickable-strong">
                            {{ isset($data['buy']) ? number_format($data['buy'], 4) : '-' }}
                        </strong>
                    </td>

                    {{-- Sell --}}
                    <td
                        @click.stop="$wire.setExchange('{{ $data['to'] }}', '{{ $data['from'] }}', {{ $data['sell'] ?? 0 }}, 'sell', '{{ e($data['sell_factor'] ?? '') }}')">
                        <strong class="clickable-strong">
                            {{ isset($data['sell']) ? number_format($data['sell'], 4) : '-' }} </strong>
                    </td>

                </tr>
            @endforeach
        </tbody>
    </table>
</div>
