<div wire:poll.10s="refreshRates">
    <h4>Live Exchange Rates ({{ config('Orange.exchange.default') }})</h4>
    <table class="table table-sm">
        <thead>
            <tr>
                <th>From / To</th>
                <th>Buy</th>
                <th>Sell</th>
            </tr>
        </thead>
        <tbody>
        <tbody>
            @foreach ($rates as $from => $targets)
                @foreach ($targets as $to => $price)
                    <tr style="cursor: pointer" x-data>
                        <td>{{ $from }} / {{ $to }}</td>

                        {{-- BUY (TRY -> USD), click triggers inverse direction --}}
                        <td
                            @click.stop="$wire.setExchange('{{ $to }}', '{{ $from }}', {{ $price['buy'] }}, 'buy', '{{ $price['buy_key'] }}')">
                            {{ number_format($price['buy'], 4) }}
                        </td>

                        {{-- SELL (USD -> TRY) --}}
                        <td
                            @click.stop="$wire.setExchange('{{ $from }}', '{{ $to }}', {{ $price['sell'] }}, 'sell', '{{ $price['sell_key'] }}')">
                            {{ number_format($price['sell'], 4) }}
                        </td>
                    </tr>
                @endforeach
            @endforeach

        </tbody>

        </tbody>
    </table>
</div>
