 <div class="container-xxl flex-grow-1 container-p-y">
     <h5 class="fw-bold py-3 mb-4">أسعار الصرف</h5>

     <div class="row">
         <!-- Live Exchange Prices -->
         <div class="col-xl-4 col-lg-4 col-md-4">
             <div class="card mb-4">
                 <div class="card-body">
                     <h5 class="card-title text-center">سعر الشاشة</h5>
                     <div class="card-body p-0">
                         @livewire('exchange.live-rates')
                     </div>
                 </div>
             </div>
         </div>

         <!-- Form -->
         <div class="col-xl-8 col-lg-8 col-md-8">
             <div class="card mb-4">
                 <div class="card-body">
                     <h5 class="card-title text-center">اضافة</h5>

                     <form wire:submit.prevent="submit">
                         <div class="row">
                             <div class="col-md-6 select2_content">
                                 <label class="form-label">من</label>
                                 <x-Mulk.select2 class="form-select" wire:model="from_currency">
                                     @foreach ($currencies as $currency)
                                         <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                     @endforeach
                                 </x-Mulk.select2>
                                 @error('from_currency')
                                     <span class="text-danger">{{ $message }}</span>
                                 @enderror
                             </div>
                             <div class="col-md-6 select2_content">
                                 <label class="form-label">الى</label>
                                 <x-Mulk.select2 class="form-select" wire:model.live="to_currency">
                                     @foreach ($currencies as $currency)
                                         <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                     @endforeach
                                 </x-Mulk.select2>
                                 @error('to_currency')
                                     <span class="text-danger">{{ $message }}</span>
                                 @enderror
                             </div>

                             <div class="col-md-6">
                                 <label class="form-label">النوع</label>
                                 <select class="form-select" wire:model.live="type">
                                     <option value="balance">رصيد</option>
                                     <option value="transfer">حوالات</option>
                                 </select>
                             </div>

                             <div class="col-md-6">
                                 <label class="form-label">مصدر السعر</label>
                                 <select class="form-select" wire:model.live="price_source">
                                     <option value="static">ثابت</option>
                                     <option value="api">API</option>
                                 </select>
                                 @error('price_source')
                                     <span class="text-danger">{{ $message }}</span>
                                 @enderror
                             </div>

                             @if ($price_source === 'static')
                                 <div class="col-md-6">
                                     <label class="form-label">السعر الثابت</label>
                                     <input type="text" wire:model="static_price" class="form-control"
                                         placeholder="مثلاً 40.25">
                                     @error('static_price')
                                         <span class="text-danger">{{ $message }}</span>
                                     @enderror
                                 </div>
                             @else
                                 <div class="col-md-6">
                                     <label class="form-label">المفتاح (API Key)</label>
                                     <input type="text" wire:model="api_key" class="form-control"
                                         placeholder="ALIS_TRY_USD">
                                     @error('api_key')
                                         <span class="text-danger">{{ $message }}</span>
                                     @enderror
                                 </div>
                                 <div class="col-md-3">
                                     <label class="form-label">الفرق</label>
                                     <input type="text" wire:model="difference" class="form-control"
                                         placeholder="مثلاً -0.2">
                                     @error('difference')
                                         <span class="text-danger">{{ $message }}</span>
                                     @enderror
                                 </div>
                             @endif
                             <div class="col-md-3">
                                 <label class="form-label">المعامل</label>
                                 <select class="form-select" wire:model="operation">
                                     <option value="*">ضرب</option>
                                     <option value="/">قسمة</option>
                                 </select>
                                 @error('operation')
                                     <span class="text-danger">{{ $message }}</span>
                                 @enderror
                             </div>
                             <div class="col-md-6">
                                 <label class="form-label">تفعيل للعملاء</label>
                                 <select class="form-select" wire:model="active_for_customers">
                                     <option value="1">فعال</option>
                                     <option value="0">غير فعال</option>
                                 </select>
                             </div>

                             <div class="col-md-6">
                                 <label class="form-label">&nbsp;</label>
                                 <button class="btn btn-primary form-control"
                                     type="submit">{{ $editingId ? 'تحديث' : 'اضافة' }}</button>
                             </div>
                         </div>
                     </form>

                 </div>
             </div>
         </div>

         <!-- Balance Prices Table -->
         <div class="col-xl-12">
             <div class="card mb-4">
                 <div class="card-body">
                     <h5 class="text-center">سعر قص الرصيد</h5>
                     <div class="table-responsive">
                         <table class="table text-right">
                             <thead>
                                 <tr>
                                     <th>من</th>
                                     <th>الى</th>
                                     <th>المصدر</th>
                                     <th>القيمة</th>
                                     <th>المعامل</th>
                                     <th>API Key</th>
                                     <th>تفعيل</th>
                                     <th>العمليات</th>
                                 </tr>
                             </thead>
                             <tbody>
                                 @foreach ($balancePrices as $row)
                                     <tr>
                                         <td>{{ $row->from_currency }}</td>
                                         <td>{{ $row->to_currency }}</td>
                                         <td>{{ $row->price_source }}</td>
                                         <td>{{ $row->price_source === 'static' ? $row->static_price : exchange_rate($row->from_currency, $row->to_currency) }}
                                         </td>
                                         <td>{{ $row->operation }}</td>
                                         <td>{{ $row->api_key }}</td>
                                         <td>{{ $row->active_for_customers ? '✅' : '❌' }}</td>
                                         <td>
                                             <button class="btn btn-sm btn-info"
                                                 wire:click="edit({{ $row->id }})">✏️</button>
                                             <button class="btn btn-sm btn-danger"
                                                 wire:click="delete({{ $row->id }})">🗑️</button>
                                         </td>
                                     </tr>
                                 @endforeach
                             </tbody>
                         </table>
                     </div>
                 </div>
             </div>
         </div>

         <!-- Transfer Prices Table -->
         <div class="col-xl-12">
             <div class="card mb-4">
                 <div class="card-body">
                     <h5 class="text-center">سعر قص الحوالات</h5>
                     <div class="table-responsive">
                         <table class="table text-right">
                             <thead>
                                 <tr>
                                     <th>من</th>
                                     <th>الى</th>
                                     <th>المصدر</th>
                                     <th>القيمة</th>
                                     <th>المعامل</th>
                                     <th>API Key</th>
                                     <th>تفعيل</th>
                                     <th>العمليات</th>
                                 </tr>
                             </thead>
                             <tbody>
                                 @foreach ($transferPrices as $row)
                                     <tr>
                                         <td>{{ $row->from_currency }}</td>
                                         <td>{{ $row->to_currency }}</td>
                                         <td>{{ $row->price_source }}</td>
                                         <td>{{ $row->price_source === 'static' ? $row->static_price : exchange_rate($row->from_currency, $row->to_currency, 'transfer') }}
                                         </td>
                                         <td>{{ $row->operation }}</td>
                                         <td>{{ $row->api_key }}</td>
                                         <td>{{ $row->active_for_customers ? '✅' : '❌' }}</td>
                                         <td>
                                             <button class="btn btn-sm btn-info"
                                                 wire:click="edit({{ $row->id }})">✏️</button>
                                             <button class="btn btn-sm btn-danger"
                                                 wire:click="delete({{ $row->id }})">🗑️</button>
                                         </td>
                                     </tr>
                                 @endforeach
                             </tbody>
                         </table>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>
