<div class="account-row" style="margin-left: {{ $level * 20 }}px;">
    <div class="bg-gray-50 rounded-lg p-3 mb-2 hover:bg-gray-100 transition-colors group">
        <div class="flex items-center justify-between">
            <!-- Left Section: Action Buttons + Account Info -->
            <div class="flex items-center space-x-3 rtl:space-x-reverse flex-1">
                <!-- Action Buttons -->
                <div class="flex items-center space-x-2 rtl:space-x-reverse">
                    <!-- Delete Button -->
                    <button wire:click="deleteAccount"
                        class="w-8 h-8 bg-red-500 hover:bg-red-600 rounded-full flex items-center justify-center transition-all duration-200 shadow-sm hover:shadow-md"
                        title="حذف">
                        <i class="ti ti-trash text-white text-xs"></i>
                    </button>

                    <!-- Edit Button -->
                    <button wire:click="editAccount"
                        class="w-8 h-8 bg-gray-600 hover:bg-gray-700 rounded-full flex items-center justify-center transition-all duration-200 shadow-sm hover:shadow-md"
                        title="تعديل">
                        <i class="ti ti-edit text-white text-xs"></i>
                    </button>

                    <!-- Add Child Button -->
                    <button wire:click="addChildAccount"
                        class="w-8 h-8 bg-amber-500 hover:bg-amber-600 rounded-full flex items-center justify-center transition-all duration-200 shadow-sm hover:shadow-md"
                        title="إضافة حساب فرعي">
                        <i class="ti ti-plus text-white text-xs"></i>
                    </button>
                </div>

                <!-- Account Info -->
                <div class="flex-1">
                    <div class="flex items-center space-x-2 rtl:space-x-reverse">
                        <!-- Expand/Collapse Icon -->
                        @if ($this->hasChildren)
                            <button wire:click="toggle" class="text-gray-500 hover:text-gray-700 transition-colors">
                                <i class="ti {{ $expanded ? 'ti-chevron-down' : 'ti-chevron-right' }} text-sm"></i>
                            </button>
                        @else
                            <div class="w-4"></div>
                        @endif

                        <!-- Account Code and Name -->
                        <span class="text-sm font-medium text-gray-900">
                            {{ $account->code }} {{ $this->accountName }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Right Section: Balance (if needed) -->
            @if ($this->balances->isNotEmpty())
                <div class="text-right">
                    <div class="text-sm font-medium {{ $this->totalBalance >= 0 ? 'text-green-600' : 'text-red-600' }}">
                        {{ number_format(abs($this->totalBalance), 2) }}
                        @if ($this->totalBalance < 0)
                            -
                        @endif
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Children -->
    @if ($expanded && $this->children->isNotEmpty())
        <div class="children-container">
            @foreach ($this->children as $child)
                @livewire('ledger.modern-account-tree-node', [
                    'account' => $child,
                    'level' => $level + 1,
                    'search' => $search,
                    'expandedNodes' => $expandedNodes,
                ])
            @endforeach
        </div>
    @endif
    <style>
        .account-row {
            position: relative;
        }

        /* Clean, minimal styling for Vuext template */
        .account-row .bg-gray-50 {
            border: 1px solid #e5e7eb;
        }

        .account-row:hover .bg-gray-50 {
            border-color: #d1d5db;
        }

        /* Smooth animations */
        .children-container {
            animation: slideDown 0.2s ease-out;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-5px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Perfect round buttons */
        .account-row button {
            transition: all 0.2s ease;
            border-radius: 50% !important;
            aspect-ratio: 1;
        }

        .account-row button:hover {
            transform: scale(1.1);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        }

        /* Ensure perfect circular shape */
        .account-row button i {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Search highlight */
        .search-highlight {
            background-color: #fef3c7;
            padding: 1px 2px;
            border-radius: 2px;
        }
    </style>

</div>
