<div class="card">
    <div class="card-header">
        <h4 class="card-title">Export Transfers Report</h4>
    </div>

    <div class="card-body">
        <form wire:submit.prevent="export">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="reportType" class="form-label">Report Type</label>
                    <select wire:model="reportType" id="reportType" class="form-select">
                        <option value="outgoing">Outgoing Transfers</option>
                        <option value="incoming">Incoming Transfers</option>
                    </select>
                </div>

                <div class="col-md-4">
                    <label for="fromDate" class="form-label">From Date</label>
                    <x-Mulk.date type="date" wire:model="fromDate" id="fromDate" class="form-control" />
                </div>

                <div class="col-md-4">
                    <label for="toDate" class="form-label">To Date</label>
                    <x-Mulk.date type="date" wire:model="toDate" id="toDate" class="form-control" />
                </div>
            </div>

            <div class="mt-4 d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">
                    <i class="ti ti-download me-1"></i> Export
                </button>
            </div>
        </form>

        {{-- Dynamic Progress Bar --}}
        @if ($batchId)
            <div class="mt-4" wire:poll.1000ms="checkBatch">
                <label class="form-label">Export Progress</label>
                <div class="progress" style="height: 20px;">
                    <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" role="progressbar"
                        style="width: {{ $progress }}%;" aria-valuenow="{{ $progress }}" aria-valuemin="0"
                        aria-valuemax="100">
                        {{ $progress }}%
                    </div>
                </div>
            </div>
        @endif

        {{-- Download link --}}
        @if ($filePath)
            <div class="mt-4">
                <a href="{{ Storage::disk('public')->url($filePath) }}" target="_blank" class="btn btn-success"
                    download>
                    <i class="ti ti-file-download me-1"></i> Download Report
                </a>
            </div>
        @endif
    </div>
</div>
