<div class="col-12 p-5">
    <div class="card">
        <div class="card-body">
            <div class="row">

                <div class="space-y-6">

                    <!-- Notification Channels Toggle -->
                    <div>
                        <h4 class="text-lg font-semibold mb-2 flex items-center">
                            <i data-lucide="bell" class="w-5 h-5 mr-2 text-blue-500"></i>
                            Notification Channels
                        </h4>
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                            @foreach ($channels as $channel)
                                <div class="flex items-center justify-between bg-gray-50 px-4 py-3 rounded-xl shadow-sm">
                                    <div class="flex items-center gap-2 text-gray-700 font-medium capitalize">
                                        <i class="w-5 h-5 text-purple-600 ti ti-{{ $icons[$channel] }}"></i>
                                        {{ $channel }}
                                    </div>

                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" class="sr-only peer" wire:model="enabledChannels"
                                            value="{{ $channel }}">
                                        <div
                                            class="w-11 h-6 bg-gray-300 peer-focus:outline-none rounded-full peer peer-checked:bg-purple-600 transition">
                                        </div>
                                        <div
                                            class="absolute left-1 top-1 w-4 h-4 bg-white rounded-full transition peer-checked:translate-x-5">
                                        </div>
                                    </label>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <hr class="my-4 border-gray-300">

                    <!-- Event-Template Assignment -->
                    <h4 class="text-2xl font-bold text-gray-800 flex items-center gap-2 mt-8">
                        <i data-lucide="sliders" class="w-6 h-6 text-purple-600"></i>
                        Event Templates
                    </h4>

                    @foreach ($events as $event)
                        <div class="border rounded-xl p-6 shadow-sm bg-gray-50 space-y-4">
                            <h5 class="text-lg font-semibold text-gray-800">{{ $eventLabels[$event] }}</h5>

                            <div class="grid md:grid-cols-{{ count($enabledChannels) }} gap-6">
                                @foreach ($enabledChannels as $channel)
                                    <div>
                                        <label class="block text-sm font-medium text-gray-600 mb-1 capitalize">
                                            {{ ucfirst($channel) }} Template
                                        </label>
                                        <select
                                            wire:model="notificationTemplates.{{ $event }}.{{ $channel }}"
                                            class=" form-control w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500">
                                            <option value="">-- Select Template --</option>
                                            @foreach ($templates[$channel] as $template)
                                                <option value="{{ $template->id }}">{{ $template->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach



                </div>

            </div>

        </div>
        <div class="card-footer">
            <div class="row justify-content-center">
                <div class="col-auto p-2">
                    <button class="btn btn-primary" wire:click="save"><i class="ti ti-check me-1"></i>Save</button>
                </div>
            </div>
        </div>

    </div>
</div>
