<div class="col-12 p-5">
    <div class="card">


        <div class="card-body">
            <form method="POST">
                @csrf
                @method('PUT')

                {{-- 2FA Toggle --}}
                <div class="mb-2">
                    <label class="form-label d-flex justify-content-between align-items-center">
                        Two-Factor Authentication (2FA)
                        <div class="form-check form-switch">
                            <input type="checkbox" name="two_factor_enabled" class="form-check-input" id="twoFactorSwitch"
                                {{ old('two_factor_enabled', $user->two_factor_enabled) ? 'checked' : '' }}>
                        </div>
                    </label>
                    <small class="text-muted">Adds extra security by requiring a verification code during login.</small>
                </div>

                {{-- Change Password --}}
                <div class="mb-2">
                    <label for="current_password" class="form-label">Current Password</label>
                    <input type="password" id="current_password" name="current_password" class="form-control" required>
                </div>

                <div class="mb-2">
                    <label for="new_password" class="form-label">New Password</label>
                    <input type="password" id="new_password" name="new_password" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label for="new_password_confirmation" class="form-label">Confirm New Password</label>
                    <input type="password" id="new_password_confirmation" name="new_password_confirmation"
                        class="form-control" required>
                </div>

                {{-- Session Management --}}
                <div class="mb-3">
                    <button type="button" class="btn btn-outline-danger" wire:click="logoutOtherSessions">
                        Logout Other Devices
                    </button>
                    <small class="text-muted d-block mt-1">Log out from all other devices except this one.</small>
                </div>

                {{-- Submit --}}
                <div class="text-end">
                    <button type="submit" class="btn btn-primary">Update Security Settings</button>
                </div>
            </form>
        </div>
    </div>

</div>
