<div>
    <div class="card">
        <div class="card-header">

        </div>
        <div class="card-body">
            <div class="row g-3">
                @if (!auth()->guard('agent')->check())
                    <div class="col-md-6 select2_content">
                        <label class="form-label"> العميل </label>

                        <x-Mulk.select2 class="form-control" wire:model.live="accountId">
                            <option value="">{{ __('general.select') }}</option>
                            @foreach ($accounts as $account)
                                <option value="{{ $account->code }}">
                                    {{ optional($account->names->where('language', app()->getLocale())->first())->name }}-{{ $account->code }}--{{ $account->agent->code ?? '' }}
                                </option>
                            @endforeach
                        </x-Mulk.select2>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label"> تضمين الحركات غير المستلمة </label>
                        <br /> <input class="form-check-input" type="checkbox" />

                    </div>
                @endif


                <div class="col-md-6 select2_content">
                    <label class="form-label">{{ __('general.currency') }}</label>

                    <x-Mulk.select2 class="form-control" wire:model.live="currency">
                        <option value="">{{ __('general.select') }}</option>
                        @foreach ($currencies as $currency)
                            <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                        @endforeach
                    </x-Mulk.select2>
                </div>

                <div class="col-md-6">
                    <label class="form-label"> الوقت </label>

                    <select class="select2 form-select" wire:model="dateFilter" wire:change="onDateFilterChange">
                        <option value="custom">تحديد التاريخ</option>
                        <option value="today">اليوم فقط</option>
                        <option value="this_month">هذا الشهر فقط</option>
                        <option value="this_year">هذا العام فقط</option>
                        <option value="all">الكل</option>
                    </select>
                </div>
                @if ($dateFilter === 'custom')
                    <div class="col-md-6">
                        <label class="form-label">{{ __('general.from_date') }}</label>
                        <x-Mulk.date class="form-control" wire:model="fromDate" />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">{{ __('general.to_date') }}</label>
                        <x-Mulk.date class="form-control" wire:model="toDate" />
                    </div>
                @endif

                <div class="col-md-6">
                    <button class="btn btn-primary form-control" wire:click="applyFilter">كشف حساب</button>
                </div>
                <div class="col-md-6">
                    <button class="btn btn-info form-control" type="button" id="btnExportPdf">طباعة </button>
                </div>
            </div>

        </div>
    </div>
</div>
