<div>
    <div class="card p-3 m-3">
        <div class="card-header">
            <h5 class="card-title">Create Template</h5>
        </div>
        <div class="card-body">
            <form wire:submit.prevent="store">
                <div class="mb-3">
                    <label for="name" class="form-label">Name</label>
                    <input type="text" class="form-control" id="name" wire:model="template.name" required>
                    @error('template.name')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="mb-3 select2_content">
                    <label for="name" class="form-label">Type</label>
                    <x-Mulk.select2 class="form-select" wire:model.live="template.type">
                        <option value="">Select</option>
                        @foreach ($types as $type)
                            <option value="{{ $type }}">{{ $type }}</option>
                        @endforeach
                    </x-Mulk.select2>
                    @error('template.type')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="mb-2">
                    @foreach ($keys as $key => $value)
                        <button type="button" class="btn btn-sm btn-outline-primary"
                            onclick="insertVariable('{{ $key }}')">{{ $value }}</button>
                    @endforeach

                </div>
                <div class="mb-3">
                    <label for="body" class="form-label">Body</label>
                    <div wire:ignore>
                        <div id="full-editor">


                        </div>
                        @error('body')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <input id="quill-content" type="hidden" wire:model="template.content">
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">Save</button>
                </div>


            </form>
        </div>
    </div>

</div>
