<div>
    <!-- Account Selection -->
    <div class="mb-4">
        <label for="account-select" class="form-label">{{ __('Select Account') }}</label>
        <select id="account-select" wire:model.live="selectedAccount" class="form-select"
            wire:change="accountChanged($event.target.value)">
            <option value="">{{ __('All Accounts') }}</option>
            @foreach ($this->getAvailableAccounts() as $account)
                <option value="{{ $account->code }}" {{ $selectedAccount == $account->code ? 'selected' : '' }}>
                    {{ $account->name }} ({{ $account->code }})
                </option>
            @endforeach
        </select>

        <!-- Debug button -->
        <button type="button" wire:click="refreshTable" class="btn btn-sm btn-secondary ms-2">
            {{ __('Test Refresh') }}
        </button>
    </div>

    <!-- Transaction DataTable -->
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">{{ __('Transactions') }}</h4>
            @if ($selectedAccount)
                <small class="text-muted">
                    {{ __('Account Type') }}: {{ ucfirst($accountType ?? 'Unknown') }}
                </small>
            @endif
        </div>
        <div class="card-body">
            <!-- This div will contain your existing DataTable -->
            <div id="{{ $tableId }}"></div>
        </div>
    </div>

    @push('page-script')
        <script>
            let transactionTable;

            // Function to get columns based on account type
            function getColumnsForAccount(accountType) {
                if (accountType && accountType !== 'cashier') {
                    // Regular account columns (without fees and receiver)
                    return [{
                            data: 'id',
                            name: 'id',
                            title: '#'
                        },
                        {
                            data: 'date',
                            name: 'date',
                            title: '{{ __('statements.date') }}'
                        },
                        {
                            data: 'type',
                            name: 'type',
                            title: '{{ __('statements.type') }}'
                        },
                        {
                            data: 'reference',
                            name: 'reference',
                            title: '{{ __('statements.reference') }}'
                        },
                        {
                            data: 'description',
                            name: 'description',
                            title: '{{ __('statements.description') }}'
                        },
                        {
                            data: 'debit_amount',
                            name: 'debit_amount',
                            title: '{{ __('statements.debit') }}'
                        },
                        {
                            data: 'credit_amount',
                            name: 'credit_amount',
                            title: '{{ __('statements.credit') }}'
                        },
                        {
                            data: 'balance',
                            name: 'balance',
                            title: '{{ __('statements.balance') }}'
                        },
                        {
                            data: 'review',
                            name: 'review',
                            title: '{{ __('statements.review') }}'
                        }
                    ];
                } else {
                    // Cashier account columns (includes fees and receiver)
                    return [{
                            data: 'id',
                            name: 'id',
                            title: '#'
                        },
                        {
                            data: 'date',
                            name: 'date',
                            title: '{{ __('statements.date') }}'
                        },
                        {
                            data: 'type',
                            name: 'type',
                            title: '{{ __('statements.type') }}'
                        },
                        {
                            data: 'reference',
                            name: 'reference',
                            title: '{{ __('statements.reference') }}'
                        },
                        {
                            data: 'send_fee',
                            name: 'send_fee',
                            title: '{{ __('statements.send_fee') }}',
                            width: '5%'
                        },
                        {
                            data: 'delivery_fee',
                            name: 'delivery_fee',
                            title: '{{ __('statements.delivery_fee') }}',
                            width: '5%'
                        },
                        {
                            data: 'description',
                            name: 'description',
                            title: '{{ __('statements.description') }}'
                        },
                        {
                            data: 'receiver',
                            name: 'receiver',
                            title: '{{ __('statements.receiver') }}'
                        },
                        {
                            data: 'debit_amount',
                            name: 'debit_amount',
                            title: '{{ __('statements.debit') }}'
                        },
                        {
                            data: 'credit_amount',
                            name: 'credit_amount',
                            title: '{{ __('statements.credit') }}'
                        },
                        {
                            data: 'balance',
                            name: 'balance',
                            title: '{{ __('statements.balance') }}'
                        },
                        {
                            data: 'review',
                            name: 'review',
                            title: '{{ __('statements.review') }}'
                        }
                    ];
                }
            }

            // Function to initialize or reinitialize the DataTable
            function initializeOrRefreshTable() {
                const accountType = @this.accountType;
                const columns = getColumnsForAccount(accountType);

                // If table already exists, destroy it
                if (transactionTable) {
                    transactionTable.destroy();
                }

                // Initialize new table with updated columns
                transactionTable = $('#{{ $tableId }}').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '{{ route('transactions.data') }}',
                        data: function(d) {
                            d.account = @this.selectedAccount;
                            d.filters = window.filters || {};
                        }
                    },
                    columns: columns,
                    dom: '<"row"' +
                        '<"col-md-2"<"ms-n2"l>>' +
                        '<"col-md-10"<"dt-action-buttons text-xl-end text-lg-start text-md-end text-start d-flex align-items-center justify-content-end flex-md-row flex-column mb-6 mb-md-0 mt-n6 mt-md-0"fB>>' +
                        '>r' +
                        't' +
                        '<"row"' +
                        '<"col-sm-12 col-md-6"i>' +
                        '<"col-sm-12 col-md-6"p>' +
                        '>',
                    lengthMenu: [
                        [25, 50, 100, 250],
                        [25, 50, 100, 250]
                    ],
                    order: [
                        [0, "desc"]
                    ],
                    buttons: []
                });
            }

            // Initialize table on page load
            $(document).ready(function() {
                initializeOrRefreshTable();
            });

            // Listen for Livewire events to refresh the table
            document.addEventListener('livewire:refreshTransactionTable', (event) => {
                console.log('Event received:', event.detail);

                // Update the account type for column selection
                const accountType = event.detail.accountType;
                console.log('Account type:', accountType);

                // Refresh the table with new columns
                setTimeout(() => {
                    initializeOrRefreshTable();
                }, 100);
            });

            // Alternative event listener for older Livewire versions
            if (typeof Livewire !== 'undefined') {
                Livewire.on('refreshTransactionTable', (data) => {
                    alert(data.accountType);
                    console.log('Legacy event received:', data);
                    setTimeout(() => {
                        initializeOrRefreshTable();
                    }, 100);
                });
            }

            // Watch for Livewire property changes
            Livewire.hook('message.processed', (message, component) => {
                if (component.fingerprint.name === 'transaction-table') {
                    console.log('Component updated, refreshing table...');
                    setTimeout(() => {
                        initializeOrRefreshTable();
                    }, 100);
                }
            });
        </script>
    @endpush
</div>
