<div>
    <div class="modal fade" id="TransferInfoModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">
                        <i class="ti ti-info-circle me-1"></i>
                        {{ __('transfers.transfer_info') }}
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped align-middle mb-0">
                            <thead class="bg-primary text-center text-white" style="color: white !important;">
                                <tr>
                                    <th class="text-white fw-bold text-center">{{ __('رقم') }}</th>
                                    <th class="text-white text-center fw-bold">{{ __('تاريخ') }}</th>
                                    <th class="text-white text-center fw-bold">{{ __('لنا') }}</th>
                                    <th class="text-white fw-bold text-center">{{ __('علينا') }}</th>
                                    <th class="text-white fw-bold text-center">{{ __('من') }}</th>
                                    <th class="text-white fw-bold text-center">{{ __('الى') }}</th>
                                    <th class="text-white text-center fw-bold">{{ __('الربح') }}</th>
                                    <th class="text-white text-center fw-bold">{{ __('المستفيد') }}</th>
                                    <th class="text-white text-center fw-bold">{{ __('النوع') }}</th>
                                </tr>
                            </thead>
                            <tbody class="text-center">
                                @if ($transfer)
                                    <tr>
                                        <td><span class="badge bg-label-secondary">{{ $transfer->reference }}</span>
                                        </td>
                                        <td>{{ $transfer->created_at }}</td>
                                        <td><span class="badge bg-label-success">{!! PriceFormat($transfer->amount, $transfer->currency) !!}</span></td>
                                        <td><span class="badge bg-label-success">{!! PriceFormat($transfer->delivery_amount, $transfer->delivery_currency) !!}</span></td>
                                        <td>{!! getAgentHtml($transfer->sender) !!}</td>
                                        <td>{!! getAgentHtml($transfer->receiver) !!}</td>
                                        <td>{{ PriceFormat($transfer->send_fee - $transfer->delivery_fee) }}</td>
                                        <td>{{ $transfer->recipient_name }}</td>
                                        <td><span class="badge bg-label-primary">{{ __($transfer->type) }}</span></td>
                                    </tr>
                                    <!-- صف الملاحظات -->
                                    <tr>
                                        <td colspan="9">
                                            <div class="p-3 border rounded bg-light text-start">
                                                <strong>{{ __('ملاحظات') }}:</strong>
                                                <div class="mt-2 fs-5">
                                                    {{ $transfer->notes }}
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>

                    @if ($transfer)
                        <div class="mt-4 text-center">

                            @if ($transfer->status == 'pending' || (strtolower($transfer->type) == 'booking' && $transfer->status == 'completed'))
                                <button type="button" class="btn btn-danger me-2" title="{{ __('actions.cancel') }}"
                                    x-on:click="$dispatch('CancelTransferConfirm', { transfer_id: '{{ $transfer->id }}' })">
                                    <i class="ti ti-circle-x"></i> {{ __('الغاء') }}
                                </button>
                            @endif

                            <button type="button" class="btn btn-info me-2"
                                x-on:click="$dispatch('ShowTransferReceipt', { transfer_id: '{{ $transfer->id }}' })">
                                <i class="ti ti-bell"></i> {{ __('اشعار') }}
                            </button>
                            <a href="{{ route('Transfers.edit', $transfer->id) }}" class="btn btn-primary me-2">
                                <i class="ti ti-edit"></i> {{ __('تعديل') }}
                            </a>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                {{ __('حسنا') }}
                            </button>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
