<div>
    <!-- Money Transfer Modal -->
    <div class="modal fade" id="TransferReceiptModal" tabindex="-1" aria-hidden="true" wire:ignore.self
        data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-xl modal-simple" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"
                        wire:click="closeModal"></button>
                    <div class="text-center mb-6">
                        <h4 class="mb-2">{{ $header_text }} </h4>

                    </div>
                    @if ($transfer)
                        <div class="col-xxl">


                            <div id="receipt-content" class="receipt-wrapper">

                                {!! $transfer->getParsedReceipt($direction) !!}

                            </div>


                        </div>
                    @endif
                </div>
                <div class="modal-footer d-flex justify-content-center flex-wrap gap-2">

                    <button class="btn btn-outline-primary mx-1" onclick="printReceipt()">
                        🖨 طباعة
                    </button>
                    <button class="btn btn-outline-success mx-1" onclick="downloadPDF()">
                        📥 تحميل PDF
                    </button>
                    <button class="btn btn-outline-info mx-1" onclick="captureImage()">
                        📸 التقاط صورة
                    </button>
                    <button onclick="captureImageToClipboard()">📋 نسخ الصورة</button>

                    <button class="btn btn-outline-warning mx-1" onclick="shareReceipt()">
                        🔗 مشاركة
                    </button>

                    <button class="btn btn-outline-secondary mx-1" onclick="copyReceiptAsText()">
                        📄 نسخ كنص
                    </button>

                    <button class="btn btn-secondary mx-1" data-bs-dismiss="modal" wire:click="closeModal">
                        ❌ إغلاق
                    </button>

                </div>
            </div>
        </div>
    </div>
    <style>
        .toast-notification {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            padding: 15px 20px;
            z-index: 9999;
            transform: translateX(100%);
            transition: transform 0.3s ease;
            max-width: 300px;
        }

        .toast-notification.show {
            transform: translateX(0);
        }

        .toast-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .toast-message {
            color: #333;
            font-size: 14px;
        }

        .toast-close {
            background: none;
            border: none;
            font-size: 18px;
            color: #999;
            cursor: pointer;
            margin-left: 10px;
        }

        .toast-close:hover {
            color: #333;
        }

        .toast-success {
            border-left: 4px solid #28a745;
        }

        .toast-error {
            border-left: 4px solid #dc3545;
        }

        .toast-info {
            border-left: 4px solid #17a2b8;
        }

        .receipt-wrapper {
            direction: rtl;
            font-family: 'Cairo', sans-serif;
            background: #fff;
            padding: 30px;
            border: 3px dashed #2c7be5;
            max-width: 850px;
            margin: auto;
            font-size: 14px;
        }

        .receipt-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .receipt-header .logo img {
            width: 100px;
        }

        .receipt-header .details {
            text-align: right;
        }

        .section {
            margin-top: 20px;
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
        }

        .section h4 {
            margin-bottom: 10px;
            font-weight: bold;
            color: #333;
        }

        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 10px;
        }

        .text-blue {
            color: #007bff;
            font-weight: bold;
        }

        .text-red {
            color: #dc3545;
            font-weight: bold;
        }

        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 13px;
            color: #555;
        }
    </style>

    <script>
        // Prevent modal from closing when clicking outside or pressing ESC
        document.addEventListener('DOMContentLoaded', function() {
            const modal = document.getElementById('TransferReceiptModal');
            if (modal) {
                // Prevent closing on backdrop click
                modal.addEventListener('click', function(event) {
                    if (event.target === modal) {
                        event.preventDefault();
                        event.stopPropagation();
                        return false;
                    }
                });

                // Prevent closing on ESC key
                document.addEventListener('keydown', function(event) {
                    if (event.key === 'Escape' && modal.classList.contains('show')) {
                        event.preventDefault();
                        event.stopPropagation();
                        return false;
                    }
                });
            }
        });

        // Function to allow modal closing (called by Livewire)
        function allowModalClose() {
            window.allowModalClose = true;
        }

        // Listen for Livewire event to allow modal closing
        document.addEventListener('allowModalClose', function() {
            allowModalClose();
        });

        function copyReceiptAsText() {
            try {
                const receiptContent = document.getElementById('receipt-content');
                if (receiptContent) {
                    // Get the text content (stripped of HTML tags)
                    const textContent = receiptContent.innerText || receiptContent.textContent;

                    // Copy to clipboard
                    navigator.clipboard.writeText(textContent).then(function() {
                        // Show success message
                        showToast('تم نسخ الإيصال كنص بنجاح!', 'success');
                    }).catch(function(err) {
                        // Fallback for older browsers
                        fallbackCopyTextToClipboard(textContent);
                    });
                } else {
                    showToast('لم يتم العثور على محتوى الإيصال', 'error');
                }
            } catch (error) {
                console.error('Error copying receipt:', error);
                showToast('حدث خطأ أثناء نسخ الإيصال', 'error');
            }
        }

        function fallbackCopyTextToClipboard(text) {
            const textArea = document.createElement('textarea');
            textArea.value = text;
            textArea.style.position = 'fixed';
            textArea.style.left = '-999999px';
            textArea.style.top = '-999999px';
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                const successful = document.execCommand('copy');
                if (successful) {
                    showToast('تم نسخ الإيصال كنص بنجاح!', 'success');
                } else {
                    showToast('فشل في نسخ الإيصال', 'error');
                }
            } catch (err) {
                showToast('حدث خطأ أثناء نسخ الإيصال', 'error');
            }

            document.body.removeChild(textArea);
        }

        function showToast(message, type = 'info') {
            // Create toast element
            const toast = document.createElement('div');
            toast.className = `toast-notification toast-${type}`;
            toast.innerHTML = `
                <div class="toast-content">
                    <span class="toast-message">${message}</span>
                    <button class="toast-close" onclick="this.parentElement.parentElement.remove()">×</button>
                </div>
            `;

            // Add to page
            document.body.appendChild(toast);

            // Show toast
            setTimeout(() => toast.classList.add('show'), 100);

            // Auto remove after 3 seconds
            setTimeout(() => {
                if (toast.parentElement) {
                    toast.classList.remove('show');
                    setTimeout(() => {
                        if (toast.parentElement) {
                            toast.remove();
                        }
                    }, 300);
                }
            }, 3000);
        }
    </script>



</div>
