<div>
    @foreach ($statsByCurrency as $currency => $stats)
        <h5 class="mb-3">{{ $currency }}</h5>
        <div class="row mb-4 g-4">

            <!-- Total Transfers -->
            <div class="col-sm-6 col-xl-3">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="content-left">
                                <h3 class="mb-1">{{ $stats['totalTransfers'] }}</h3>
                                <small class="text-muted">{{ __('transfers.total_transfers') }}</small>
                            </div>
                            <span class="badge bg-label-primary rounded-circle p-2">
                                <i class="ti ti-arrows-shuffle ti-lg"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Amount -->
            <div class="col-sm-6 col-xl-3">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="content-left">
                                <h3 class="mb-1">{{ number_format($stats['totalAmount'], 2) }} {{ $currency }}
                                </h3>
                                <small class="text-muted">{{ __('transfers.total_amount_sent') }}</small>
                            </div>
                            <span class="badge bg-label-success rounded-circle p-2">
                                <i class="ti ti-wallet ti-lg"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Total Fees -->
            <div class="col-sm-6 col-xl-3">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="content-left">
                                <h3 class="mb-1">{{ number_format($stats['totalFees'], 2) }} {{ $currency }}</h3>
                                <small class="text-muted">{{ __('transfers.total_fees_collected') }}</small>
                            </div>
                            <span class="badge bg-label-danger rounded-circle p-2">
                                <i class="ti ti-coins ti-lg"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Delivered Transfers -->
            <div class="col-sm-6 col-xl-3">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="content-left">
                                <h3 class="mb-1">{{ $stats['delivered'] }}</h3>
                                <small class="text-muted">{{ __('transfers.total_delivered_transfers') }}</small>
                                <div class="mt-2">
                                    <span class="badge bg-label-success">{{ __('transfers.delivered') }}</span>
                                </div>
                            </div>
                            <span class="badge bg-label-info rounded-circle p-2">
                                <i class="ti ti-check ti-lg"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    @endforeach
</div>
