<div>

    <h5 class="mb-3">Transfer Fee Packages ({{ $currency }})</h5>

    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <label class="form-label">{{ __('general.name') }}</label>
            <input type="text" class="form-control" wire:model.defer="package.name">
            @error('package.name')
                <small class="text-danger">{{ $message }}</small>
            @enderror
        </div>

        <div class="col-md-3">
            <label class="form-label">Currency</label>
            <select class="form-select" wire:model="package.currency">
                @foreach ($availableCurrencies as $code => $name)
                    <option value="{{ $code }}">{{ $name }}</option>
                @endforeach
            </select>
            @error('package.currency')
                <small class="text-danger">{{ $message }}</small>
            @enderror
        </div>
        <div class="col-md-3">
            <label class="form-label">Type</label>
            <select class="form-select" wire:model="package.type">
                <option value="transfer">Transfer</option>
                <option value="approval">Approval</option>
            </select>
            @error('package.currency')
                <small class="text-danger">{{ $message }}</small>
            @enderror
        </div>
        <div class="col-md-3">
            <label class="form-label">Agent (optional)</label>
            <select class="form-select" wire:model="package.agent_id">
                <option value="">Global</option>
                @foreach ($availableAgents as $id => $name)
                    <option value="{{ $id }}">{{ $name }}</option>
                @endforeach
            </select>
        </div>
    </div>

    <div class="row g-3 mb-3">
        <div class="col-md-1">
            <label class="form-label">{{ __('transferpackages.start') }}</label>
            <input type="number" class="form-control" wire:model.defer="start" min="0">
        </div>

        <div class="col-md-1">
            <label class="form-label">{{ __('transferpackages.end') }}</label>
            <input type="number" class="form-control" wire:model.defer="end" min="0">
        </div>

        <div class="col-md-2">
            <label class="form-label">{{ __('transferpackages.step') }}</label>
            <input type="number" class="form-control" wire:model.defer="step" min="1">
        </div>

        <div class="col-md-2">
            <label class="form-label">{{ __('transferpackages.base_send_fee') }}</label>
            <input type="number" class="form-control" wire:model.defer="baseSendFee" step="0.01" min="0">
        </div>

        <div class="col-md-2">
            <label class="form-label">{{ __('transferpackages.send_fee_increment') }}</label>
            <input type="number" class="form-control" wire:model.defer="sendFeeIncrement" step="0.01"
                min="0">
        </div>

        <div class="col-md-2">
            <label class="form-label">{{ __('transferpackages.base_receive_fee') }}</label>
            <input type="number" class="form-control" wire:model.defer="baseReceiveFee" step="0.01" min="0">
        </div>

        <div class="col-md-2">
            <label class="form-label">{{ __('transferpackages.receive_fee_increment') }}</label>
            <input type="number" class="form-control" wire:model.defer="receiveFeeIncrement" step="0.01"
                min="0">
        </div>

        <div class="col-md-2 d-flex align-items-end">
            <button class="btn btn-info w-100" wire:click="generatePackages" type="button">
                Generate
            </button>
        </div>
    </div>

    @foreach ($packages as $index => $pkg)
        <div class="row g-2 align-items-end mb-2">
            <div class="col-md-3">
                <label class="form-label">{{ __('transferpackages.min_amount') }}</label>
                <input type="number" wire:model.defer="packages.{{ $index }}.min" class="form-control"
                    step="0.01" min="0">
                @error('packages.' . $index . '.min')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="col-md-3">
                <label class="form-label">{{ __('transferpackages.max_amount') }}</label>
                <input type="number" wire:model.defer="packages.{{ $index }}.max" class="form-control"
                    step="0.01" min="0">
                @error('packages.' . $index . '.max')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>
            <div class="col-md-2">
                <label class="form-label">{{ __('transferpackages.send_fee') }}</label>
                <div class="input-group">
                    <input type="number" wire:model.defer="packages.{{ $index }}.send_fee"
                        class="form-control" step="0.01" min="0">
                    <select class="form-select" wire:model.defer="packages.{{ $index }}.send_fee_type">
                        <option value="fixed">{{ $package['currency'] }}</option>
                        <option value="percent">‰</option> {{-- per thousand --}}
                    </select>
                </div>
                @error('packages.' . $index . '.send_fee')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="col-md-2">
                <label class="form-label">{{ __('transferpackages.receive_fee') }}</label>
                <div class="input-group">
                    <input type="number" wire:model.defer="packages.{{ $index }}.receive_fee"
                        class="form-control" step="0.01" min="0">
                    <select class="form-select" wire:model.defer="packages.{{ $index }}.receive_fee_type">
                        <option value="fixed">{{ $package['currency'] }}</option>
                        <option value="percent">‰</option>
                    </select>
                </div>
                @error('packages.' . $index . '.receive_fee')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>

            <div class="col-md-2">
                <button class="btn btn-outline-danger" wire:click="removePackage({{ $index }})"
                    type="button" title="Remove Package">
                    <i class="ti ti-trash"></i>
                </button>
            </div>
        </div>
    @endforeach

    <div class="d-flex gap-2 mt-3">
        <button wire:click="addPackage" class="btn btn-secondary" type="button">
            <i class="ti ti-plus"></i> {{ __('actions.add') }}
        </button>
        <button wire:click="save" class="btn btn-primary" type="button">
            <i class="ti ti-device-floppy"></i> {{ __('actions.save') }}
        </button>
    </div>

    @if (session()->has('success'))
        <div class="alert alert-success mt-2">
            {{ session('success') }}
        </div>
    @endif
</div>
