<div>
    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="trial-balance-card p-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h2 class="mb-1">
                                <i class="ti ti-calculator me-2"></i>
                                الميزانية العمومية
                            </h2>
                            <p class="mb-0 opacity-75">Trial Balance Report</p>
                        </div>
                        <div class="text-end">
                            <h4 class="mb-1">{{ now()->format('Y-m-d') }}</h4>
                            <small class="opacity-75">تاريخ التقرير</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Error Message -->
        @if ($errorMessage)
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="ti ti-alert-circle me-2"></i>
                {{ $errorMessage }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <!-- Filters Section -->
        <div class="filter-section">
            <form wire:submit.prevent="generateTrialBalance">
                <div class="row g-3">
                    <div class="col-md-2">
                        <label class="form-label fw-bold">العملة</label>
                        <select class="form-select" wire:model="currency" required>
                            <option value="">اختر العملة</option>
                            @foreach ($currencies as $curr)
                                <option value="{{ $curr->code }}">{{ $curr->code }} -
                                    {{ $curr->name ?? $curr->code }}</option>
                            @endforeach
                        </select>
                        @error('currency')
                            <span class="text-danger small">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="col-md-2">
                        <label class="form-label fw-bold">العمق</label>
                        <select class="form-select" wire:model="depth" required>
                            <option value="">اختر العمق</option>
                            <option value="1">مستوى 1</option>
                            <option value="2">مستوى 2</option>
                            <option value="3">مستوى 3</option>
                            <option value="4">مستوى 4</option>
                            <option value="5">مستوى 5</option>
                        </select>
                        @error('depth')
                            <span class="text-danger small">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-bold">إلى تاريخ</label>
                        <input type="date" class="form-control" wire:model="toDate" required>
                        @error('toDate')
                            <span class="text-danger small">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-bold">النطاق</label>
                        <select class="form-select" wire:model="domainUuid">
                            <option value="">جميع النطاقات</option>
                            @foreach ($domains as $domain)
                                <option value="{{ $domain->domainUuid }}">{{ $domain->name ?? $domain->domainUuid }}
                                </option>
                            @endforeach
                        </select>
                        @error('domainUuid')
                            <span class="text-danger small">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="col-md-2">
                        <label class="form-label fw-bold">خيارات</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" wire:model="includeZeroBalances"
                                id="include_zero_balances">
                            <label class="form-check-label" for="include_zero_balances">
                                تضمين الأرصدة الصفرية
                            </label>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12 text-center">
                        <button type="submit" class="btn btn-primary btn-lg me-2" wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                <i class="ti ti-refresh me-2"></i>
                                إنشاء التقرير
                            </span>
                            <span wire:loading>
                                <i class="ti ti-loader me-2"></i>
                                جاري إنشاء التقرير...
                            </span>
                        </button>

                        @if ($showResults)
                            <button type="button" class="btn btn-success btn-lg me-2" wire:click="exportToExcel">
                                <i class="ti ti-download me-2"></i>
                                تصدير Excel
                            </button>
                        @endif

                        <button type="button" class="btn btn-outline-secondary btn-lg" wire:click="resetForm">
                            <i class="ti ti-rotate me-2"></i>
                            إعادة تعيين
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Loading Indicator -->
        @if ($isLoading)
            <div class="text-center my-5">
                <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
                    <span class="visually-hidden">جاري التحميل...</span>
                </div>
                <h5 class="mt-3">جاري إنشاء التقرير...</h5>
                <p class="text-muted">يرجى الانتظار</p>
            </div>
        @endif

        <!-- Summary Cards -->
        @if ($showResults && !empty($summary))
            <div class="row mb-4">
                <div class="col-md-2">
                    <div class="summary-card">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">إجمالي الحسابات</h6>
                                <h4 class="mb-0">{{ $summary['total_accounts'] ?? 0 }}</h4>
                            </div>
                            <div class="text-primary">
                                <i class="ti ti-calculator ti-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="summary-card" style="border-left-color: #1976d2;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">إجمالي المدين</h6>
                                <h4 class="mb-0 text-primary">{{ number_format($summary['total_debit'], 2) }}</h4>
                            </div>
                            <div class="text-primary">
                                <i class="ti ti-arrow-up ti-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="summary-card" style="border-left-color: #d32f2f;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">إجمالي الدائن</h6>
                                <h4 class="mb-0 text-danger">{{ number_format($summary['total_credit'], 2) }}</h4>
                            </div>
                            <div class="text-danger">
                                <i class="ti ti-arrow-down ti-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="summary-card">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">إجمالي الرصيد</h6>
                                <h4 class="mb-0 balance-positive">{{ number_format($summary['total_balance'], 2) }}
                                </h4>
                            </div>
                            <div class="text-success">
                                <i class="ti ti-calculator ti-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="summary-card {{ $summary['is_balanced'] ? 'success' : 'danger' }}">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">حالة التوازن</h6>
                                <h4 class="mb-0">
                                    @if ($summary['is_balanced'])
                                        ✅ متوازن
                                    @else
                                        ⚠️ غير متوازن
                                    @endif
                                </h4>
                                <small class="text-muted">
                                    @if ($summary['is_balanced'])
                                        إجمالي الرصيد = صفر
                                    @else
                                        إجمالي الرصيد: {{ number_format($summary['total_balance'], 2) }}
                                    @endif
                                </small>
                            </div>
                            <div class="{{ $summary['is_balanced'] ? 'text-success' : 'text-danger' }}">
                                <i
                                    class="ti {{ $summary['is_balanced'] ? 'ti-check-circle' : 'ti-alert-circle' }} ti-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <!-- Trial Balance Table -->
        @if ($showResults && !empty($trialBalanceData))
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="ti ti-table me-2"></i>
                        تفاصيل الميزانية العمومية
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>كود الحساب</th>
                                    <th>اسم الحساب</th>
                                    <th>نوع الحساب</th>
                                    <th>العمق</th>
                                    <th class="text-end">مدين</th>
                                    <th class="text-end">دائن</th>
                                    <th class="text-end">الرصيد الإجمالي</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($trialBalanceData as $account)
                                    <tr class="account-row depth-{{ $account['depth'] }}">
                                        <td>
                                            @if ($account['depth'] > 1)
                                                <span style="color: #6c757d; margin-right: 5px;">└─</span>
                                            @endif
                                            <span class="account-code">{{ $account['account_code'] }}</span>
                                            <span
                                                class="depth-indicator depth-{{ $account['depth'] }} ms-2">{{ $account['depth'] }}</span>
                                        </td>
                                        <td>
                                            @if ($account['depth'] > 1)
                                                <span style="color: #6c757d; margin-right: 5px;">└─</span>
                                            @endif
                                            {{ $account['account_name'] }}
                                        </td>
                                        <td>
                                            <span
                                                class="badge bg-{{ $this->getAccountTypeColor($account['account_type']) }}">
                                                {{ $account['account_type'] }}
                                            </span>
                                        </td>
                                        <td class="text-center">{{ $account['depth'] }}</td>
                                        <td
                                            class="text-end debit-column {{ $this->getBalanceClass($account['debit_balance'] ?? 0) }}">
                                            {{ number_format($account['debit_balance'] ?? 0, 2) }}
                                        </td>
                                        <td
                                            class="text-end credit-column {{ $this->getBalanceClass($account['credit_balance'] ?? 0) }}">
                                            {{ number_format($account['credit_balance'] ?? 0, 2) }}
                                        </td>
                                        <td class="text-end {{ $this->getBalanceClass($account['total_balance']) }}">
                                            {{ number_format($account['total_balance'], 2) }}
                                        </td>

                                    </tr>
                                @endforeach
                            </tbody>
                            <!-- Totals Row -->
                            @if ($showResults && !empty($trialBalanceData))
                                <tfoot class="table-dark">
                                    <tr>
                                        <th colspan="4" class="text-center">
                                            <strong>الإجمالي</strong>
                                        </th>
                                        <th class="text-center">
                                            <strong class="text-primary">
                                                {{ number_format($summary['total_debit'] ?? 0, 2) }}
                                            </strong>
                                        </th>
                                        <th class="text-center">
                                            <strong class="text-danger">
                                                {{ number_format($summary['total_credit'] ?? 0, 2) }}
                                            </strong>
                                        </th>
                                        <th class="text-center">
                                            <strong
                                                class="{{ ($summary['total_balance'] ?? 0) == 0 ? 'text-success' : 'text-warning' }}">
                                                {{ number_format($summary['total_balance'] ?? 0, 2) }}
                                            </strong>
                                        </th>
                                    </tr>
                                    <tr
                                        class="{{ $summary['is_balanced'] ?? false ? 'table-success' : 'table-warning' }}">
                                        <td colspan="7" class="text-center">
                                            <strong>
                                                @if ($summary['is_balanced'] ?? false)
                                                    ✅ الميزانية متوازنة - إجمالي الرصيد = صفر
                                                @else
                                                    ⚠️ الميزانية غير متوازنة - إجمالي الرصيد:
                                                    {{ number_format($summary['total_balance'], 2) }}
                                                    <br>
                                                    <small class="text-muted">
                                                        قد يكون هناك خطأ في البيانات أو في طريقة الحساب
                                                    </small>
                                                @endif
                                            </strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        @endif

        <!-- No Data Message -->
        @if ($showResults && empty($trialBalanceData))
            <div class="text-center my-5">
                <i class="ti ti-database-off ti-3x text-muted mb-3"></i>
                <h5>لا توجد بيانات</h5>
                <p class="text-muted">لم يتم العثور على حسابات تطابق المعايير المحددة</p>
            </div>
        @endif
    </div>

    <style>
        .trial-balance-card {
            background: linear-gradient(135deg, rgb(140, 158, 241) 0%, rgb(157, 206, 238) 100%);
            color: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .filter-section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            border: 1px solid #e9ecef;
        }

        .summary-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            border-left: 4px solid #28a745;
        }

        .summary-card.success {
            border-left-color: #28a745;
            background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
        }

        .summary-card.danger {
            border-left-color: #dc3545;
            background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
        }

        .summary-card.warning {
            border-left-color: #ffc107;
            background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
        }

        .table-success {
            background-color: #d4edda !important;
        }

        .table-warning {
            background-color: #fff3cd !important;
        }

        .table-danger {
            background-color: #f8d7da !important;
        }

        .account-row {
            transition: all 0.3s ease;
        }

        .account-row:hover {
            background-color: #f8f9fa;
            transform: translateX(5px);
        }

        .account-code {
            font-family: 'Courier New', monospace;
            font-weight: bold;
            color: #495057;
        }

        .balance-positive {
            color: #28a745;
            font-weight: bold;
        }

        .balance-negative {
            color: #dc3545;
            font-weight: bold;
        }

        .balance-zero {
            color: #6c757d;
        }

        /* Debit and Credit column styling */
        .debit-column {
            background-color: #e3f2fd !important;
            color: #1976d2;
            font-weight: bold;
        }

        .credit-column {
            background-color: #ffebee !important;
            color: #d32f2f;
            font-weight: bold;
        }

        .debit-column:hover {
            background-color: #bbdefb !important;
        }

        .credit-column:hover {
            background-color: #ffcdd2 !important;
        }

        .depth-indicator {
            display: inline-block;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            text-align: center;
            line-height: 20px;
            font-size: 12px;
            font-weight: bold;
            color: white;
        }

        .depth-1 {
            background-color: #007bff;
        }

        .depth-2 {
            background-color: #28a745;
        }

        .depth-3 {
            background-color: #ffc107;
        }

        .depth-4 {
            background-color: #dc3545;
        }

        .depth-5 {
            background-color: #6f42c1;
        }

        /* Level-based Row Styling */
        .account-row {
            transition: all 0.3s ease;
        }

        /* Level 1 - Blue */
        .account-row[class*="depth-1"] {
            background-color: #e3f2fd !important;
            border-left: 4px solid #2196f3;
            font-weight: 600;
        }

        .account-row[class*="depth-1"]:hover {
            background-color: #bbdefb !important;
        }

        /* Level 2 - Green */
        .account-row[class*="depth-2"] {
            background-color: #e8f5e8 !important;
            border-left: 4px solid #4caf50;
            font-weight: 500;
        }

        .account-row[class*="depth-2"]:hover {
            background-color: #c8e6c9 !important;
        }

        /* Level 3 - Orange */
        .account-row[class*="depth-3"] {
            background-color: #fff3e0 !important;
            border-left: 4px solid #ff9800;
            font-weight: 500;
        }

        .account-row[class*="depth-3"]:hover {
            background-color: #ffe0b2 !important;
        }

        /* Level 4 - Purple */
        .account-row[class*="depth-4"] {
            background-color: #f3e5f5 !important;
            border-left: 4px solid #9c27b0;
            font-weight: 500;
        }

        .account-row[class*="depth-4"]:hover {
            background-color: #e1bee7 !important;
        }

        /* Level 5 - Red */
        .account-row[class*="depth-5"] {
            background-color: #ffebee !important;
            border-left: 4px solid #f44336;
            font-weight: 500;
        }

        .account-row[class*="depth-5"]:hover {
            background-color: #ffcdd2 !important;
        }
    </style>
</div>
