<div>

    <div class="modal fade" id="addUserModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl modal-simple modal-dialog-centered modal-add-new-role" wire:ignore.self>
            <div class="modal-content">
                <div class="modal-body">

                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-6">
                        <h4 class="role-title mb-2">{{ __('users.add_new_user') }}</h4>

                    </div>
                    <div class="row">

                        <div id="wizard-property-listing" class="bs-stepper vertical mt-2">
                            <div class="bs-stepper-header border-end">
                                <div class="step @if ($step == 1) active @endif"
                                    data-target="#personal-details">
                                    <button type="button" class="step-trigger">
                                        <span class="bs-stepper-circle"><i class="ti ti-users ti-md"></i></span>
                                        <span class="bs-stepper-label">
                                            <span class="bs-stepper-title">{{ __('users.user_details') }}</span>

                                        </span>
                                    </button>
                                </div>
                                <div class="line"></div>
                                <div class="step @if ($step == 2) active @endif"
                                    data-target="#property-details">
                                    <button type="button" class="step-trigger">
                                        <span class="bs-stepper-circle"><i class="ti ti-home ti-md"></i></span>
                                        <span class="bs-stepper-label">
                                            <span class="bs-stepper-title">{{ __('address.address_details') }}</span>

                                        </span>
                                    </button>
                                </div>




                            </div>


                            <div class="bs-stepper-content">
                                <form id="wizard-property-listing-form" onSubmit="return false">
                                    <div class="content @if ($step == 1) active @endif">
                                        <div class="row">
                                            <div class="mb-6 col-md-6">
                                                <label class="form-label"
                                                    for="add-user-fullname">{{ __('users.first_name') }}</label>
                                                <input type="text" class="form-control"
                                                    wire:model="user.firstname" />
                                                @error('user.firstname')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="mb-6 col-md-6">
                                                <label class="form-label"
                                                    for="add-user-fullname">{{ __('users.last_name') }}</label>
                                                <input type="text" class="form-control" wire:model="user.lastname" />
                                                @error('user.lastname')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>





                                            <div class="mb-6 col-md-6">
                                                <label class="form-label">{{ __('users.phone_number') }}</label>
                                                <input type="text" class="form-control" wire:model="user.phone" />
                                                @error('user.phone')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="mb-6 col-md-6">
                                                <label class="form-label"
                                                    for="add-user-email">{{ __('users.email') }}</label>
                                                <input type="text" class="form-control" wire:model="user.email" />
                                                @error('user.email')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>


                                            <div class="mb-6 select2_content col-md-6">
                                                <label class="form-label"
                                                    for="add-user-fullname">{{ __('users.gender') }}</label>
                                                <x-Mulk.select2 wire:model="user.gender">
                                                    <option value="">Select Gender</option>
                                                    <option value="m">Male</option>
                                                    <option value="f">Female</option>
                                                </x-Mulk.select2>
                                                @error('user.gender')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="mb-6 select2_content col-md-6">
                                                <label class="form-label"
                                                    for="user-role">{{ __('users.role') }}</label>
                                                <x-Mulk.select2 wire:model="role" searchable>
                                                    <option value="">Select Role</option>
                                                    @foreach ($roles as $roleItem)
                                                        <option value="{{ $roleItem->name }}">{{ $roleItem->name }}
                                                        </option>
                                                    @endforeach
                                                </x-Mulk.select2>
                                                @error('role')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                            <div class="mb-6 col-md-6 select2_content">
                                                <label class="form-label">{{ __('users.agent') }}</label>
                                                <x-Mulk.select2 wire:model="user.agent_id">
                                                    <option value="">Select Agent</option>
                                                    @foreach ($agents as $agent)
                                                        <option value="{{ (string) $agent->id }}">{{ $agent->name }}
                                                        </option>
                                                    @endforeach
                                                </x-Mulk.select2>
                                                @error('user.agent_id')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                        </div>


                                        <div class="col-12 d-flex justify-content-between">
                                            <button class="btn btn-label-secondary btn-prev" disabled> <i
                                                    class="ti ti-arrow-left ti-xs me-sm-2 me-0"></i>
                                                <span
                                                    class="align-middle d-sm-inline-block d-none">{{ __('actions.previous') }}</span>
                                            </button>
                                            <button type="button" class="btn btn-primary btn-next"
                                                wire:click="NextStep"> <span
                                                    class="align-middle d-sm-inline-block d-none me-sm-2">{{ __('actions.next') }}
                                                </span>
                                                <i class="ti ti-arrow-right ti-xs"></i></button>
                                        </div>
                                    </div>
                                    <div class="content @if ($step == 2) active @endif">
                                        <div class="row g-6">


                                            <div class="col-sm-6">
                                                <label class="form-label">{{ __('address.zipcode') }}</label>
                                                <input type="number" id="plZipCode" wire:model="address.zipcode"
                                                    class="form-control @error('address.zipcode') is-invalid @enderror"
                                                    placeholder="99950" />
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label">{{ __('address.country') }}</label>
                                                <select wire:modeld="address.country" class="select2 form-select"
                                                    data-allow-clear="true">


                                                    <option value="Turkey">Turkey</option>

                                                </select>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label">{{ __('address.state') }}</label>
                                                <input type="text" id="plState" wire:model="address.state"
                                                    class="form-control @error('address.state') is-invalid @enderror"
                                                    placeholder="California" />
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label">{{ __('address.city') }}</label>
                                                <input type="text" id="plCity" wire:model="address.city"
                                                    class="form-control @error('address._city') is-invalid @enderror"
                                                    placeholder="Los Angeles" />
                                            </div>



                                            <div class="col-lg-12">
                                                <label class="form-label">{{ __('address.address') }}</label>
                                                <input type="text" id="plAddress"
                                                    wire:model="address.full_address"
                                                    class="form-control @error('address.full_address') is-invalid @enderror"
                                                    rows="2" placeholder="12, Business Park">
                                            </div>
                                            <div class="col-12 d-flex justify-content-between">
                                                <button class="btn btn-label-secondary btn-prev"
                                                    wire:click="PrevStep"> <i
                                                        class="ti ti-arrow-left ti-xs me-sm-2 me-0"></i> <span
                                                        class="align-middle d-sm-inline-block d-none">
                                                        {{ __('actions.previous') }}</span>
                                                </button>
                                                <button class="btn btn-success btn-submit btn-next"
                                                    wire:click="AddUser" wire:loading.attr="disabled"><span
                                                        class="align-middle d-sm-inline-block d-none me-sm-2">{{ __('actions.submit') }}</span><i
                                                        class="ti ti-check ti-xs"></i></button>
                                            </div>
                                        </div>
                                    </div>



                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>





</div>
