<div>
    <div class="row">
        <!-- User Sidebar -->
        <div class="col-xl-4 col-lg-5 order-1 order-md-0">
            <!-- User Card -->
            <div class="card mb-6">
                <div class="card-body pt-12">
                    <div class="user-avatar-section">
                        <div class=" d-flex align-items-center flex-column">
                            <img class="img-fluid rounded mb-4" src="{{ $user->getAvatar() }}" height="120" width="120"
                                alt="User avatar" />
                            <div class="media-body change-btn position-absolute">
                                <label for="account-upload"
                                    class="btn btn-sm btn-primary  waves-effect waves-float waves-light "><i
                                        class="fa fa-edit"></i> </label>
                                <form wire:submit="save">
                                    <input type="file" id="account-upload" wire:model="avatar" hidden=""
                                        accept="image/*">
                                </form>
                            </div>
                            <div class="user-info text-center">

                                <span class="badge bg-label-secondary"> {{ __('general.' . $user->type) }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div class="border rounded p-5 mt-5">
                            <div class="row gap-4 gap-sm-0">
                                <div class="col-12 col-sm-6">
                                    <div class="d-flex gap-2 align-items-center">
                                        <div class="badge rounded bg-label-primary p-1"><i
                                                class="ti ti-currency-dollar ti-sm"></i></div>
                                        <h6 class="mb-0 fw-normal">{{ __('general.balance') }}</h6>
                                    </div>
                                    <h6 class="my-2">{{ PriceFormat($user->balance) }}</h6>

                                </div>
                                <div class="col-12 col-sm-6">
                                    <div class="d-flex gap-2 align-items-center">
                                        <div class="badge rounded bg-label-info p-1"><i
                                                class="ti ti-chart-pie-2 ti-sm"></i></div>
                                        <h6 class="mb-0 fw-normal">{{ __('general.outstanding') }}</h6>
                                    </div>
                                    <h6 class="my-2">{{ PriceFormat($user->OutstandingInvoicesAmount()) }}</h6>

                                </div>

                            </div>
                        </div>

                    </div>
                    <div class="divider">
                        <div class="divider-text ">
                            <h6><strong>{{ __('general.' . $user->type) }} {{ __('general.information') }}</strong></h6>
                        </div>
                    </div>
                    <div class="info-container">
                        <ul class="list-unstyled mb-6">
                            <li class="mb-2">
                                <span class="h6">{{ __('general.id_number') }} : </span>
                                <span><strong>{{ $user->id_number }}</strong> <a href="javascript:void(0)"
                                        class="clipboard" title="Copy to clipboard" aria-label="{{ $user->code }}"><i
                                            class="ti ti-clipboard"></i></a></span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">{{ __('general.name') }} : </span>
                                <span><strong>{{ $user->name }}</strong> <a href="javascript:void(0)"
                                        class="clipboard" title="Copy to clipboard" aria-label="{{ $user->name }}"><i
                                            class="ti ti-clipboard"></i></a></span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">{{ __('address.email') }}:</span>
                                <span><strong>{{ $user->email }}</strong> <a href="javascript:void(0)"
                                        class="clipboard" title="Copy to clipboard" aria-label="{{ $user->email }}"><i
                                            class="ti ti-clipboard"></i></a> </span>
                                <span class="  bg-label-warning  rounded" title="Email is not verified">
                                    <i class="fa fad fa-exclamation-circle fa-lg"
                                        style="width:1.2em;height:1.2em"></i></span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">{{ __('address.phone') }}:</span>
                                <span><strong>{{ $user->phone }}</strong> <a href="javascript:void(0)"
                                        class="clipboard" title="Copy to clipboard" aria-label="{{ $user->email }}"><i
                                            class="ti ti-clipboard"></i></a></span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">{{ __('address.state') }}:</span>
                                <span><strong>{{ $user->getPrimaryAddress()->state ?? '-' }}</strong></span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">{{ __('address.city') }}:</span>
                                <span><strong>{{ $user->getPrimaryAddress()->city ?? '-' }}</strong></span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">{{ __('address.address') }}:</span>
                                <span><strong>{{ $user->getPrimaryAddress()->full_address ?? '-' }}</strong></span>
                            </li>
                            <li class="mb-2">
                                <span class="h6">{{ __('general.created_at') }}:</span>
                                <span><strong>{{ $user->created_at }}</strong></span>
                            </li>




                        </ul>
                        <div class="d-flex justify-content-center">
                            <a href="javascript:;" class="btn btn-primary me-4" data-bs-toggle="modal"
                                data-bs-target="#addUserModal">{{ __('actions.edit') }}</a>
                            <a href="javascript:;"
                                class="btn @if ($user->is_active) btn-label-success @else btn-label-danger @endif suspend-user"
                                wire:click="ChangeStatus">
                                @if ($user->is_active)
                                    {{ __('general.disable') }}
                                @else
                                    {{ __('general.activate') }}
                                @endif
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /User Card -->
            <!-- Plan Card -->
            <div class="card mb-6 border border-2 border-primary rounded primary-shadow">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <span class="badge bg-label-primary">Map</span>

                    </div>

                    <div wire:ignore class="leaflet-map" id="map"></div>

                </div>

            </div>
            <!-- /Plan Card -->
        </div>
        <!--/ User Sidebar -->


        <!-- User Content -->
        <div class="col-xl-8 col-lg-7 order-0 order-md-1">
            <!-- User Pills -->
            <div class="nav-align-top">
                <ul class="nav nav-pills flex-column flex-md-row flex-wrap mb-6 row-gap-2">

                    @if ($user->type == 'Tenant')
                        <li class="nav-item"><button class="nav-link @if ($tab == 'dashboard') active @endif"
                                wire:click="changeTab('dashboard')"><i
                                    class="ti ti-user-check ti-sm me-1_5"></i>Dashboard
                            </button></li>
                        <li class="nav-item"><button class="nav-link @if ($tab == 'contract') active @endif"
                                wire:click="changeTab('contract')"><i
                                    class="ti ti-user-check ti-sm me-1_5"></i>{{ __('general.contracts') }}
                            </button></li>

                        <li class="nav-item"><button class="nav-link @if ($tab == 'invoices') active @endif"
                                wire:click="changeTab('invoices')"><i
                                    class="ti ti-user-check ti-sm me-1_5"></i>{{ __('general.invoices') }}
                            </button></li>
                    @endif

                    <li class="nav-item"><a class="nav-link @if ($tab == 'notes') active @endif"
                            href="javascript:void(0);" wire:click="changeTab('notes')"><i
                                class="ti ti-bookmark ti-sm me-1_5"></i>{{ __('general.notes') }}</a></li>
                    <li class="nav-item"><a class="nav-link @if ($tab == 'documents') active @endif"
                            wire:click="changeTab('documents')" href="javascript:void(0);"><i
                                class="ti ti-bell ti-sm me-1_5"></i>{{ __('general.documents') }}</a></li>

                </ul>
            </div>

            @if ($tab == 'features')
                <livewire:components.features :features="$features" :selected_features="$selected_features" :model="$model" :modelid="$modelid" />
                <livewire:components.facades :facades="$facades" :selected_facades="$selected_facades" :model="$model" />
            @elseif ($tab == 'notes')
                <livewire:components.notes :className="App\Models\User::class" :class_id="$user->id" />
            @elseif ($tab == 'documents')
                <livewire:components.documents :className="App\Models\User::class" :class_id="$user->id" />
            @elseif ($tab == 'details')
                <div class="row" style="display: flex;">
                    <div class="col-sm-6 d-flex flex-column">
                        <div class="card card-action mb-6 flex-grow-1 d-flex flex-column">
                            <div class="card-header">
                                <h5 class="card-action-title mb-0"> Details</h5>
                                <div class="card-action-element">
                                    <ul class="list-inline mb-0">
                                        <li class="list-inline-item">
                                            <a href="javascript:void(0);" class="card-reload d-flex"><i
                                                    class="tf-icons ti ti-edit scaleX-n1-rtl ti-sm"></i></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body flex-grow-1">
                                <livewire:Property.details :property="$user->property" />
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 d-flex flex-column">
                        <div class="card card-action mb-6  flex-grow-1 d-flex flex-column">
                            <div class="card-header">
                                <h5 class="card-action-title mb-0"> Tapu</h5>
                                <div class="card-action-element">
                                    <ul class="list-inline mb-0">
                                        <li class="list-inline-item">
                                            <a href="javascript:void(0);" class="card-reload d-flex"><i
                                                    class="tf-icons ti ti-rotate-clockwise-2 scaleX-n1-rtl ti-sm"></i></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body flex-grow-1">
                                <livewire:Property.tapu :property="$user->property" />
                            </div>
                        </div>
                    </div>
                    <livewire:components.fees :property="$user->property" />
                </div>
            @elseif($tab == 'dashboard')
                <livewire:user.view.dahboard :tenant="$user" />
            @elseif ($tab == 'contract')
                @if ($user->contracts()->exists())
                    <livewire:components.contract :contract="$user->contracts->first()" :model=$user :key="$tab" />
                @else
                    <x-Mulk.nodata title="{{ __('contract.no_contract_found') }}"
                        button_text="{{ __('actions.add') }}" button_id="add_new_tenant"
                        button_target="#addNewTenant" button_toggle="modal" />
                @endif
                <livewire:property.tenant.add :property="$property" :model=$user :key="$tab" />
            @elseif($tab == 'invoices')
                <livewire:invoices.list-invoice :user="$user" :property="$user->property" :key="$tab" />
            @elseif($tab == 'payments')
                <livewire:invoices.listpayments :property="$user->property" :key="$tab" />
            @endif

            <!--/ Tab Content -->

        </div>
        <!--/ User Content -->
    </div>
</div>
