@extends('layouts.layoutMaster')

@section('title', 'إدارة الأخبار')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">إدارة الأخبار</h4>
                        <a href="{{ route('news.create') }}" class="btn btn-primary">
                            <i class="bx bx-plus me-1"></i>إضافة خبر جديد
                        </a>
                    </div>
                    <div class="card-body">
                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="bx bx-check-circle me-2"></i>
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif

                        @if ($news->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>المحتوى</th>
                                            <th>الحالة</th>
                                            <th>تاريخ الإنشاء</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($news as $index => $item)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>
                                                    <div class="text-truncate" style="max-width: 300px;"
                                                        title="{{ $item->content }}">
                                                        {{ Str::limit($item->content, 100) }}
                                                    </div>
                                                </td>
                                                <td>
                                                    @if ($item->is_active)
                                                        <span class="badge bg-success">مفعل</span>
                                                    @else
                                                        <span class="badge bg-secondary">معطل</span>
                                                    @endif
                                                </td>
                                                <td>{{ $item->created_at->format('Y-m-d H:i') }}</td>
                                                <td>
                                                    <div class="btn-group" role="group">
                                                        <a href="{{ route('news.edit', $item) }}"
                                                            class="btn btn-sm btn-outline-primary" title="تعديل">
                                                            <i class="ti ti-pencil"></i>
                                                        </a>

                                                        <form action="{{ route('news.toggle-status', $item) }}"
                                                            method="POST" class="d-inline">
                                                            @csrf
                                                            @method('PATCH')
                                                            <button type="submit" class="btn btn-sm btn-outline-warning"
                                                                title="{{ $item->is_active ? 'إلغاء التفعيل' : 'تفعيل' }}">
                                                                <i class="ti ti-{{ $item->is_active ? 'x' : 'check' }}"></i>
                                                            </button>
                                                        </form>

                                                        <form action="{{ route('news.destroy', $item) }}" method="POST"
                                                            class="d-inline"
                                                            onsubmit="return confirm('هل أنت متأكد من حذف هذا الخبر؟')">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-sm btn-outline-danger"
                                                                title="حذف">
                                                                <i class="ti ti-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-center mt-3">
                                {{ $news->links() }}
                            </div>
                        @else
                            <div class="text-center py-5">
                                <i class="bx bx-news bx-lg text-muted mb-3"></i>
                                <h5 class="text-muted">لا توجد أخبار</h5>
                                <p class="text-muted">ابدأ بإضافة خبر جديد</p>
                                <a href="{{ route('news.create') }}" class="btn btn-primary">
                                    <i class="bx bx-plus me-1"></i>إضافة خبر جديد
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
