<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>كشف حساب</title>
    <style>
        body {
            font-family: 'DejaVu Sans', 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #ffffff;
            direction: rtl;
            text-align: right;
            font-size: 12px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #2c3e50;
            padding-bottom: 20px;
        }

        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 10px;
            direction: rtl;
            text-align: center;
        }

        .report-title {
            font-size: 20px;
            font-weight: bold;
            color: #34495e;
            margin-bottom: 5px;
            direction: rtl;
            text-align: center;
        }

        .report-subtitle {
            font-size: 16px;
            color: #7f8c8d;
            direction: rtl;
            text-align: center;
        }

        .statement-details {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
            direction: rtl;
        }

        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
            direction: rtl;
        }

        .details-table th,
        .details-table td {
            padding: 10px;
            text-align: right;
            border: 1px solid #dee2e6;
            direction: rtl;
        }

        .details-table th {
            background-color: #2c3e50;
            color: white;
            font-weight: bold;
            direction: rtl;
        }

        .details-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        .transactions-section {
            margin-top: 30px;
            direction: rtl;
        }

        .transactions-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
            direction: rtl;
            font-size: 10px;
        }

        .transactions-table th,
        .transactions-table td {
            padding: 6px;
            text-align: center;
            border: 1px solid #dee2e6;
            direction: rtl;
            vertical-align: middle;
        }

        .transactions-table th {
            background-color: #2c3e50;
            color: white;
            font-weight: bold;
            direction: rtl;
            font-size: 11px;
        }

        .transactions-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        .transactions-table tr:hover {
            background-color: #e9ecef;
        }

        .debit-amount {
            color: #e74c3c;
            font-weight: bold;
        }

        .credit-amount {
            color: #27ae60;
            font-weight: bold;
        }

        .balance-amount {
            color: #2c3e50;
            font-weight: bold;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            border-top: 1px solid #dee2e6;
            padding-top: 20px;
            direction: rtl;
        }

        .status-badge {
            padding: 2px 6px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
        }

        .status-outgoing {
            background-color: #e74c3c;
            color: white;
        }

        .status-incoming {
            background-color: #27ae60;
            color: white;
        }

        .debug-info {
            background: #f0f0f0;
            padding: 10px;
            border-radius: 4px;
            margin-top: 20px;
            font-size: 10px;
            direction: rtl;
        }

        /* Ensure proper RTL for all elements */
        * {
            direction: rtl;
        }

        /* Force RTL for specific elements */
        .company-name,
        .report-title,
        .report-subtitle {
            direction: rtl;
            text-align: center;
        }
    </style>
</head>

<body>
    <!-- Header Section -->
    <div class="header">
        <div class="company-name">شركة التحويلات</div>
        <div class="report-title">كشف حساب</div>
        <div class="report-subtitle">Account Statement</div>
    </div>

    <!-- Statement Details Section -->
    <div class="statement-details">
        <h3>تفاصيل الحساب</h3>
        <table class="details-table">
            <tr>
                <th>اسم الحساب</th>
                <td><strong>{{ $statementDetails['account_name'] }}</strong></td>
                <th>الرصيد السابق</th>
                <td>
                    <strong>
                        @if ($statementDetails['opening_balance'] < 0)
                            {{ number_format(abs($statementDetails['opening_balance']), 2) }} لنا
                        @else
                            {{ number_format($statementDetails['opening_balance'], 2) }} علينا
                        @endif
                    </strong>
                </td>
            </tr>
            <tr>
                <th>العملة</th>
                <td><strong>{{ $statementDetails['currency'] }}</strong></td>
                <th>الرصيد الحالي</th>
                <td>
                    <strong class="balance-amount">
                        {{ $statementDetails['balance_type'] }}
                        {{ number_format($statementDetails['current_balance'], 2) }}
                    </strong>
                </td>
            </tr>
            @if ($statementDetails['from_date'])
                <tr>
                    <th>من تاريخ</th>
                    <td><strong>{{ $statementDetails['from_date']->format('Y-m-d') }}</strong></td>
                    <th>إلى تاريخ</th>
                    <td><strong>{{ $statementDetails['to_date'] ? $statementDetails['to_date']->format('Y-m-d') : 'N/A' }}</strong>
                    </td>
                </tr>
            @endif
            <tr>
                <th>عدد الحركات</th>
                <td><strong>{{ $statementDetails['entry_count'] }}</strong></td>
                <th>رقم الصندوق</th>
                <td><strong>{{ $statementDetails['account_code'] }}</strong></td>
            </tr>
            <tr>
                <th>الحركات الصادرة</th>
                <td><strong style="color: #e74c3c;">{{ $statementDetails['out_transfers'] }}</strong></td>
                <th>الحركات الواردة</th>
                <td><strong style="color: #27ae60;">{{ $statementDetails['in_transfers'] }}</strong></td>
            </tr>
            <tr>
                <th>إجمالي المدين لنا</th>
                <td><strong class="debit-amount">{{ number_format($statementDetails['total_debit'], 2) }}</strong></td>
                <th>إجمالي الدائن علينا</th>
                <td><strong class="credit-amount">{{ number_format($statementDetails['total_credit'], 2) }}</strong>
                </td>
            </tr>
            <tr>
                <th>الرصيد كتابة</th>
                <td colspan="3" style="text-align: center;">
                    <strong style="font-size: 14px; color: #2c3e50;">
                        {{ $statementDetails['currency_words'] }}
                        {{ $statementDetails['balance_type'] }}
                    </strong>
                </td>
            </tr>
        </table>
    </div>

    <!-- Transactions Section -->
    <div class="transactions-section">
        <h3>العمليات المالية</h3>
        @if ($transactions->count() > 0)
            <table class="transactions-table">
                <thead>
                    <tr>
                        <th>التاريخ</th>
                        <th>النوع</th>
                        <th>نوع الحركة</th>
                        <th>الاتجاه</th>
                        <th>المرجع</th>
                        <th>المرسل</th>
                        <th>المستلم</th>
                        <th>الوصف</th>
                        <th>مدين</th>
                        <th>دائن</th>
                        <th>الرصيد</th>
                        <th>المستخدم</th>
                        <th>الحالة</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($transactions as $transaction)
                        <tr>
                            <td>{{ $transaction['date'] }}</td>
                            <td>{{ $transaction['type'] }}</td>
                            <td>{{ $transaction['transfer_type'] }}</td>
                            <td
                                style="color: {{ $transaction['direction'] === 'ص' ? '#e74c3c' : '#27ae60' }}; font-weight: bold;">
                                {{ $transaction['direction'] === 'ص' ? 'صادر' : ($transaction['direction'] === 'و' ? 'وارد' : $transaction['direction']) }}
                            </td>
                            <td>{{ $transaction['reference'] }}</td>
                            <td>{{ $transaction['sender'] }}</td>
                            <td>{{ $transaction['receiver'] }}</td>
                            <td>{{ $transaction['description'] }}</td>
                            <td class="debit-amount">
                                @if (is_numeric($transaction['debit']) && $transaction['debit'] > 0)
                                    {{ number_format((float) $transaction['debit'], 2) }}
                                @else
                                    -
                                @endif
                            </td>
                            <td class="credit-amount">
                                @if (is_numeric($transaction['credit']) && $transaction['credit'] > 0)
                                    {{ number_format((float) $transaction['credit'], 2) }}
                                @else
                                    -
                                @endif
                            </td>
                            <td class="balance-amount">
                                {{ is_numeric($transaction['balance']) ? number_format((float) $transaction['balance'], 2) : '0.00' }}
                            </td>
                            <td>{{ $transaction['user'] }}</td>
                            <td>{{ $transaction['status'] }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p>لا توجد عمليات مالية لهذه الفترة</p>
        @endif
    </div>

    <!-- Footer Section -->
    <div class="footer">
        <p>تم إنشاء هذا التقرير في {{ $statementDetails['generated_at']->format('Y-m-d H:i:s') }}</p>
        <p>شركة التحويلات - جميع الحقوق محفوظة</p>
    </div>

    <!-- Report Summary Section -->
    <div class="statement-details" style="margin-top: 20px;">
        <h3>ملخص التقرير</h3>
        <table class="details-table">
            <tr>
                <th>تاريخ التقرير</th>
                <td>{{ $statementDetails['generated_at']->format('Y-m-d H:i:s') }}</td>
                <th>يشمل غير المستلم</th>
                <td>{{ $statementDetails['include_unreceived'] ? 'نعم' : 'لا' }}</td>
            </tr>
            <tr>
                <th>نوع الحساب</th>
                <td>{{ $statementDetails['account_type'] }}</td>
                <th>إجمالي العمليات</th>
                <td>{{ $transactions->count() }}</td>
            </tr>
        </table>
    </div>
</body>

</html>
