<?php

use App\Http\Controllers\AccountController;
use App\Http\Controllers\Agent\DashboardController as AgentDashboardController;
use App\Http\Controllers\Agent\LoginController;
use App\Http\Controllers\AgentController;
use App\Http\Controllers\BalanceController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\StatementController;
use App\Http\Controllers\TransferController;

use App\Http\Controllers\UserManagement;
use App\Http\Middleware\EnsureAgentEmailIsVerified;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Route;

Route::domain(env("AGENT_URL", "customer.transfer.com"))->group(function () {
  //  require base_path('vendor/laravel/fortify/routes/routes.php');

  // Guest routes
  // Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');
  // Route::get('login', [LoginController::class, 'showLoginForm'])->name('agent.login');
  Route::post('login', [LoginController::class, 'login'])->name('agent.login.submit');
  Route::get('/debug', function () {
    dd('Agent debug route works');
  });
  Route::get('Admin/UpdatePassword', [LoginController::class, 'showChangePasswordForm'])->name('agent.change-password');

  // Authenticated routes
  Route::middleware(['auth:agent', 'admin.update.password', 'check.agent.status'])->group(function () {
    Route::post('logout', [LoginController::class, 'logout'])->name('agent.logout');
    Route::get('/', [AgentDashboardController::class, 'index'])->name('agent.dashboard');
    Route::get('/email/verify', function () {
      return view('AgentPanel.auth.verify-email');
    })->name('agent.verification.notice');

    Route::prefix('Transfers')->group(function () {
      Route::get("/Deliver/{id}", [TransferController::class, 'AgentDeliverTransfer'])->name('agent.dashboard.deliver_rtansfer');

      Route::get("/OutTransfers", [TransferController::class, 'OutTransfers'])->name('agent.transfers.OutTransfers');
      Route::get("/InTransfers", [TransferController::class, 'InTransfers'])->name('agent.transfers.InTransfers');
      Route::get("/Delivered", [TransferController::class, 'DeliveredTransfers'])->name('agent.transfers.DeliveredTransfers');
      Route::get("/SentApproval", [TransferController::class, 'AgentApproval'])->name('agent.transfers.AgentApproval');
      Route::get("/InApproval", [TransferController::class, 'InAgentApproval'])->name('agent.transfers.InAgentApproval');
      Route::get("OutApproval", [TransferController::class, 'OutAgentApproval'])->name('agent.transfers.OutAgentApproval');
      Route::get("/DeliveredApprovals", [TransferController::class, 'AgentDeliveredApprovals'])->name('agent.transfers.AgentDeliveredApprovals');

      Route::get("/PayTransfers", [TransferController::class, 'PayTransfer'])->name('agent.transfers.PayTransfers');
      Route::get("/CollectTransfers", [TransferController::class, 'CollectTransfer'])->name('agent.transfers.CollectTransfer');
    });

    Route::prefix('Statements')->group(function () {

      Route::get("/Agent_index", [StatementController::class, 'Agent_index'])->name('agent.statement');
      Route::get("/Cashier_index", [StatementController::class, 'Cashier_index'])->name('agent.statement.cashier');
      Route::get("/export-pdf", [StatementController::class, 'exportPdf'])->name('agent.statements.export-pdf');
    });
    Route::get("Exchange", [TransferController::class, 'AgentExchange'])->name('agent.exchange');

    Route::group(['prefix' => 'Client'], function () {

      Route::resource('/', ClientController::class);
      Route::get("/Search", [ClientController::class, 'Search']);
    });
    Route::group(['prefix' => 'Accounts'], function () {


      Route::get("/Search", [AccountController::class, 'Search']);
      Route::get("/AgentSearch", [AgentController::class, 'AgentSearch']);
    });
    Route::group(['prefix' => 'Balances',], function () {


      Route::get("/Agent_index", [BalanceController::class, 'Agent_index'])->name('agent.balances');
    });
    Route::get("/Livewatch", [TransferController::class, 'AgentLivewatch'])->name('agent.livewatch');
    Route::get("/AdvancedSearch", [TransferController::class, 'AgentAdvancedSearch'])->name('agent.advancedsearch');
    Route::group(['prefix' => 'Booking'], function () {
      Route::get("/", [TransferController::class, 'AgentBooks'])->name('agent.booking.index');
      Route::get("/add/{type?}", [TransferController::class, 'AddAgentBooking'])->name('agent.booking.add');
      Route::get("/{id}/edit", [TransferController::class, 'EditBooking'])->name('agent.booking.edit');
    });
    Route::get("/Agentsearch/Search", [AgentController::class, 'Search']);

    Route::get('/return-to-admin', function () {
      $adminId = session('impersonator_id');
      if ($adminId) {
        Auth::guard('agent')->logout();
        Auth::guard('web')->loginUsingId($adminId);
        session()->forget('impersonator_id');
      }
      return redirect()->route('admin.dashboard');
    })->name('agent.returnToAdmin');
  });
});
